* Program to dump all ZIP Code data via the ZipCodeData interface
* of the AddressObject component 
*********************************************************************************
*If you should have any comments, suggestions or improvements to these samples, 
*we welcome you to contact us at SampleCode@melissadata.com also please visit our 
*developers bulletin board at forum.melissadata.com.
*********************************************************************************

close all
clear

* Use and remove any previous records 
use zipdump alias zipdump
delete all
pack

* Use the ZipCodeData interface of the AddressObject component
ZipObject = CreateObject('AddressObject.ZipCodeData')

********************** LICENSE STRINGS *************************
*      To unlock the full functionality of Address Object,     *
*  please call a sales representative at 1-800-MELISSA ext. 3  *
*          (1-800-635-4772 x3) for a license string.           *
*         Without a valid license string, ZIPData will         *
*                 only verify Nevada ZIP Codes.                *
*                                                              *
* NOTE: Replace DEMO in the parameter with your license string *
****************************************************************
if (ZipObject.SetLicenseString("DEMO") = 0)
	@1,1 say "Component is in DEMO Mode"
endif

***************************************************************
* Set path for data files below.  The default location is
* entered.  If different, please enter the datapath between
* the quotation marks.
* The Data Files Directory must contain the following files: 
* mdAddr.dat, mdAddr.lic, mdAddr.nat, mdAddr.sfx and mdAddr.str.
***************************************************************
* Initialize the data files
if (ZipObject.Initialize("C:\Program Files\Melissa DATA\DQT\Data","C:\Program Files\Melissa DATA\DQT\Data")!=0)
	wait ZipObject.GetInitializeErrorString
	return
endif

@2,1 say "Initialized"

* Dump Nevada ZIP Code Data for some Nevada ZIP Codes
for zipx=89101 to 89112

	@3,1 say zipx

	* Get information for this ZIP Code
	result = ZipObject.FindZip(zipx)

	* Replace fields with data from ZIP Code
	do while (result=1)
		appe blank
		repl zip with ZipObject.Zip
		repl city with ZipObject.City
		repl state with ZipObject.State
		repl lat with val(ZipObject.Latitude)
		repl lng with val(ZipObject.Longitude)
		repl msa with ZIpObject.msa
		repl pmsa with ZipObject.pmsa
		repl typ with ZipObject.ZipType
		repl fips with ZipObject.CountyFips
		repl ll with ZipObject.LastLineIndicator
		repl fac with ZipObject.FacilityCode
		repl ll_no with ZipObject.LastLineNumber
		repl ll_no_pref with ZipObject.PreferredLastLineNumber
		repl auto with ZipObject.Automation

		* Get any additional data from this ZIP Code
		result = ZipObject.FindZipNext()
	enddo
endfor

* Release the component
release ZipObject
